"use strict";

var waypoint = new Waypoint({
  element: document.getElementById('counterTrigger'),
  handler: function handler(direction) {
    //customer counter
    var customerCounter = document.getElementById('customerCounter');
    var customerIncPerDay = 1360;
    var customerFromDate = "12/01/2022";
    startCounting(customerCounter, countTotalNumber(customerFromDate, customerIncPerDay, customerCounter));

    //Update realtime
    setInterval(getTotalCustomer, 10000); //update each 10 sec
    function getTotalCustomer() {
      //console.log('update 1 counter....')
      splitCounter(customerCounter, countTotalNumber(customerFromDate, customerIncPerDay, customerCounter));
    }

    //Prior Authorisation counter
    var priorCounter = document.getElementById('PriorCounter');
    var priorIncPerDay = 120;
    var priorFromDate = "12/01/2022";
    startCounting(priorCounter, countTotalNumber(priorFromDate, priorIncPerDay, priorCounter));

    //Update realtime
    setInterval(getTotalPrior, 10000); //update each 10 sec
    function getTotalPrior() {
      //console.log('update 2 counter....')
      startCounting(priorCounter, countTotalNumber(priorFromDate, priorIncPerDay, priorCounter));
    }

    //Data Entry counter
    var dataCounter = document.getElementById('DataCounter');
    var dataIncPerDay = 2700;
    var dataFromDate = "12/01/2022";
    startCounting(dataCounter, countTotalNumber(dataFromDate, dataIncPerDay, dataCounter));

    //Update realtime
    setInterval(getTotalData, 10000); //update each 10 sec
    function getTotalData() {
      //console.log('update 3 counter....')
      startCounting(dataCounter, countTotalNumber(dataFromDate, dataIncPerDay, dataCounter));
    }

    //medical counter
    var medicalCounter = document.getElementById('MedicalCounter');
    var medicalIncPerDay = 2500;
    var medicalFromDate = "12/01/2022";
    startCounting(medicalCounter, countTotalNumber(medicalFromDate, medicalIncPerDay, medicalCounter));

    //Update realtime
    setInterval(getTotalMedical, 10000); //update each 10 sec
    function getTotalMedical() {
      //console.log('update 4 counter....')
      startCounting(medicalCounter, countTotalNumber(medicalFromDate, medicalIncPerDay, medicalCounter));
    }

    //Administrative counter
    var administrativeCounter = document.getElementById('AdministrativeCounter');
    var administrativeIncPerDay = 12;
    var administrativeFromDate = "12/01/2022";
    startCounting(administrativeCounter, countTotalNumber(administrativeFromDate, administrativeIncPerDay, administrativeCounter));

    //Update realtime
    setInterval(getTotalAdmin, 10000); //update each 10 sec
    function getTotalAdmin() {
      //console.log('update 5 counter....')
      startCounting(administrativeCounter, countTotalNumber(administrativeFromDate, administrativeIncPerDay, administrativeCounter));
    }
  }
});

//Counter function
function startCounting(counter, totalCount) {
  var updateCount = function updateCount() {
    var target = +totalCount;
    var count = +counter.innerText;

    // Lower inc to slow and higher to fast
    var inc = target / 600;

    // Check if target is reached
    if (count < target) {
      // Add inc to count and output in counter
      splitCounter(counter, Math.round(count + inc));
      // Call function every ms
      setTimeout(updateCount, 1);
    } else {
      splitCounter(counter, Math.round(target));
    }
  };
  updateCount();
}

//add markup to counter character
function splitCounter(counter, target) {
  var targetSplit = target.toString().split("");
  counter.innerHTML = '<span>' + targetSplit.join('</span><span>') + '</span>';
}

//get total number of days
function getTotalNumbersOfDays(fromDate) {
  var oneDay = 24 * 60 * 60 * 1000; // hours*minutes*seconds*milliseconds
  var firstDate = new Date(fromDate);
  var secondDate = new Date();
  return Math.abs((firstDate - secondDate) / oneDay);
}

//count total number
function countTotalNumber(fromDate, incPerDay, selector, counterType) {
  var countFromDate = parseFloat(getTotalNumbersOfDays(fromDate)) * parseInt(incPerDay);
  var currentDate = new Date();
  var todayPastMinute = currentDate.getHours() * 60 + currentDate.getMinutes();
  countFromDate = countFromDate + Math.ceil(incPerDay / 1440 * todayPastMinute); //calculate with 1440 minutes(one day)
  return Math.round(countFromDate + parseInt(selector.getAttribute('data-target')));
}