"use strict";

(function ($) {
  "use strict";

  //Update Header Style and Scroll to Top
  function headerStyle() {
    if ($(".main-header").length) {
      var windowpos = $(window).scrollTop();
      var siteHeader = $(".main-header");
      var scrollLink = $(".scroll-top");
      if (windowpos >= 400) {
        siteHeader.addClass("fixed-header");
        scrollLink.addClass("open");
      } else {
        siteHeader.removeClass("fixed-header");
        scrollLink.removeClass("open");
      }
    }
  }
  headerStyle();

  //Submenu Dropdown Toggle
  if ($(".main-header li.dropdown ul").length) {
    $(".main-header .navigation li.dropdown").append('<div class="dropdown-btn"><span class="fas fa-angle-down"></span></div>');
  }

  //Mobile Nav Hide Show
  if ($(".mobile-menu").length) {
    // $('.mobile-menu .menu-box').mCustomScrollbar();

    var mobileMenuContent = $(".main-header .menu-area .main-menu").html();
    $(".mobile-menu .menu-box .menu-outer").append(mobileMenuContent);
    $(".sticky-header .main-menu").append(mobileMenuContent);

    //Dropdown Button
    $(".mobile-menu li.dropdown .dropdown-btn").on("click", function () {
      $(this).toggleClass("open");
      $(this).prev("ul").slideToggle(500);
    });
    //Dropdown Button
    $(".mobile-menu li.dropdown .dropdown-btn").on("click", function () {
      $(this).prev(".megamenu").slideToggle(900);
    });
    //Menu Toggle Btn
    $(".mobile-nav-toggler").on("click", function () {
      $("body").addClass("mobile-menu-visible");
    });

    //Menu Toggle Btn
    $(".mobile-menu .menu-backdrop,.mobile-menu .close-btn").on("click", function () {
      $("body").removeClass("mobile-menu-visible");
    });
  }

  // Scroll to a Specific Div
  if ($(".scroll-to-target").length) {
    $(".scroll-to-target").on("click", function () {
      var target = $(this).attr("data-target");
      // animate
      $("html, body").animate({
        scrollTop: $(target).offset().top
      }, 1000);
    });
  }

  // Team Carousel
  if ($(".banner-carousel").length) {
    $(".banner-carousel").owlCarousel({
      items: 1,
      loop: true,
      margin: 30,
      nav: false,
      smartSpeed: 1000,
      autoplay: 500,
      paginationSpeed: 400,
      animateIn: "fadeIn",
      // add this
      animateOut: "fadeOut",
      // and this
      dots: false
    });
  }

  /*	=========================================================================
  When document is Scrollig, do
  ========================================================================== */

  jQuery(document).on("ready", function () {
    (function ($) {
      // add your functions
      // clientsCarousel();
    })(jQuery);
  });

  /* ==========================================================================
   When document is Scrollig, do
   ========================================================================== */

  $(window).on("scroll", function () {
    headerStyle();
  });
})(window.jQuery);