<?php
$routes = array();

include(__DIR__ . '/../App/routes.php');

function init(){
    $call = getRoute();

    if($call && !empty($call->controller)){
        if(file_exists('App/Controllers/' . $call->controller . '.php')){            
            include 'App/Controllers/' . $call->controller . '.php';
        } else {
            show404();
        }
    } else {
        show404();
    }

    if(!empty($call->method) && function_exists($call->method)){
        call_user_func($call->method);
    } else {
        show404();
    }
}

function show404(){
    include 'App/Views/Templates/404.php'; 
    die();
}

function setRoute($url, $controller, $method=false, $middleware=false){
    global $routes;
    $route = new stdClass;
    $route->url = $url;
    $route->controller = $controller;
    $route->method = $method;
    $route->middleware = $middleware;

    $routes[$url] = $route;
    // array_push($routes[$url], $route);
}

function getRoutes(){
    global $routes;
    return $routes;
}

function getRoute(){
    global $routes;
    // include 'App/Views/Templates/404.php'; die();
    if(!array_key_exists(getCurrentURL(), $routes)){
        return false;
    }
    return $routes[getCurrentURL()];
}

function getCurrentURL(){
    if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')
         $url = "https://";
    else 
         $url = "http://";
    $url .= $_SERVER['HTTP_HOST'];
    
    $url .= $_SERVER['REQUEST_URI'];
    
    $url = strtok($url, '?');
    
    $url = str_replace(BASE_URL, '/', $url);
    $url = rtrim($url, '/');

    if(empty($url)){
        $url = '/';
    }

    return $url;  
}

