<?php

function contact() {
    // check if form is submitted or not
    if (empty($_POST)) {
        // load view file
        include(__DIR__ . '/../Views/Contact/contact.php');
    } else {
        // assign form data to variable
        //pr($_POST);
        $name = $_POST['name'];
        $studentId = $_POST['student_id'];
        $email = $_POST['email'];
        $phone = $_POST['phone_number'];
        $yourMessage = $_POST['your_message'];
        $attachment = $_POST['attachment'];

        // validate form data
        if (!preg_match("/^([a-zA-Z' ]+)$/", $name)) {
            redirect("contact");
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            redirect("contact");
        }
        
        if(preg_match('/^[0-9]{10}+$/', $phone)) {
            redirect("contact");
        }
        
        if(strlen($yourMessage) > 500) {
            redirect("contact");
        }

        // load model and insert data
        include(__DIR__ . '/../Models/contactModel.php');

        $result = insertContactInfo($name, $studentId, $email, $phone, $yourMessage, $attachment);

        // if inserted redirect to success
        if ($result == true) {
            redirect("contact/success");
        } else {
            redirect("contact");
        }
    }
}

function contactSuccess() {
    include(__DIR__ . '/../Views/Contact/success.php');
}
